	% Digital Filter 11.5 
	clear all
	close all
	
	WcT = 0.25*pi; WsT = 0.6*pi; Amax = 0.2829; Amin = 30;
	Rs = 1; RL = 1;  
	Omegac = tan(WcT/2); Omegas = tan(WsT/2);
	Omegas/Omegac;
	N = CH_ORDER_S(Omegac, Omegas, Amax, Amin);
	N = 3;
	%	[G, Z, P] = CH_I_POLES_S(Omegac, Omegas, Amax, Amin, N);
	Ladder = 1;
	[L, C, K] = CH_I_LADDER(Omegac, Omegas, Amax, Amin, N, Rs, RL, Ladder);
	W = linspace(0, 5*Omegas, 1000);
	Z0 = []; T=1;
	H = LADDER_2_H(N, Z0, L, C, Rs, RL, K, W, T);
	Att = MAG_2_ATT(H*2);	% The |H|max = 0.5 for a doubly 
	% terminated LC filter. We normalize the attenuation to 0 dB
	
	figure(1), PLOT_ATT_S(W, Att)
	
	R1 = L(1);	R2 = 1/C(2);	R3 = L(3);	Rs = 1; RL = 1;
	R4 = Rs + R1;
	alfa11 = 2*Rs/(Rs + R1 + R4);
	alfa12 = 2*R1/(Rs + R1 + R4);
	alfa13 = 1;
	
	R5 = RL + R3;
	alfa31 = 2*R5/(RL + R5 + R3);
	alfa32 = 2*R3/(RL+ R5 + R3);
	alfa33 = 2*RL/(RL+ R5 + R3);
	
	G1 = 1/R4;	G2 = 1/R2;	G3 = 1/R5;
	alfa21 = 2*G1/(G1 + G2 + G3);
	alfa22 = 2*G2/(G1 + G2 + G3);
	alfa23 = 2*G3/(G1 + G2 + G3);
	a1 = 1; a2 = 0; v1 = 0; v2 = 0; v3 = 0;
	for n = 1:50
		x1 = a1 + v1;
		x2 = x1 + v2;
		x3 = v2 + v3;
		v2 = v2 - alfa21*(x2 + x3);
		x4 = x2 + v2;
		b1 = a1 - alfa11*(x1 + x4);
		v1 = b1 + x4;
		x5 = v2 + x3;
		b2 = alfa33*(x5 + v3);
		v3 = -b2 + x5;
		h(n) = b2; 		a1 = 0;
	end
	figure(2),	PLOT_IMPULSE_RESPONSE_Z(h)
	[G, Z, P] = IMPULSE_2_P_Z(h, 3)
	figure(3),	PLOT_PZ_Z(Z, P)
	wT = [0:0.001:pi];
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	Att = PZ_2_ATT_Z(G, Z, P, wT); 
	figure(4), PLOT_ATT_TG_Z(Att, Taug, wT, 40, 5)		
	
	
